using System;
using System.Configuration.Install;
using System.Reflection;
using System.Threading;
using System.Configuration;
using System.ServiceProcess;

namespace gov.va.med.vbecs.Common
{
    /// <summary>
    /// SelfInstaller is a helper class for services.
    /// It provides easy way to install/uninstall windows services.
    /// CR 2732: self installation/uninstallation feature.
    /// </summary>
    public class SelfInstaller
    {
		/// <summary>
		/// Installs service.
		/// </summary>
		/// <param name="assembly_location">
		/// Full file nale fo the service assembly
		/// </param>
		/// <param name="args">
		/// input installation arguments 
		/// </param>
        public static bool InstallMe(string assembly_location, string[] args)
        {
            try
            {
                if(args == null)
                    ManagedInstallerClass.InstallHelper(
                        new string[] { assembly_location } );

                string[] combined = new string[1 + args.Length];
                int i = 0;
                foreach(string a in  args)
                {
                    combined[i++] = a;
                }
                // Last parameter is always file location
                combined[i] = assembly_location;
            
                ManagedInstallerClass.InstallHelper( combined );
            }
            catch
            {
                return false;
            }
            return true;
        }

		/// <summary>
		/// Uninstalls service.
		/// </summary>
		/// <param name="assembly_location">
		/// Full file nale fo the service assembly
		/// </param>
        public static bool UninstallMe(string assembly_location)
        {
            try
            {
                ManagedInstallerClass.InstallHelper(
                    new string[] { "/u", assembly_location } );
            }
            catch
            {
                return false;
            }
            return true;
        }

		/// <summary>
		/// Main entry point processes installation/uninstallation. 
		/// It is similar to main method but accepts some additional arguments.
		/// </summary>
		/// <param name="args">
		/// Input installation arguments 
		/// </param>
		/// <param name="service">
		/// Instance of service class that need to be registered
		/// </param>
		/// <param name="service_assembly">
		/// Instance of service's assembly class.
		/// </param>
        static public void Start(string[] args, System.ServiceProcess.ServiceBase service, System.Reflection.Assembly service_assembly)
        {
            //read service name
            string service_name = service.ServiceName;

            // Started by user
            if (Environment.UserInteractive)
            {
                // Show version information
                Console.Write(Environment.NewLine + service_assembly.FullName + ".");

                // Parsing command line
                if(args.Length == 0)
                {
                    ServiceController sc = new ServiceController(service_name, ".");
                    try
                    {
                        string s = sc.Status.ToString();  // throws exception if service does not exist
                    }
                    catch
                    {
                        Console.WriteLine(Environment.NewLine + Environment.NewLine + 
                            "Install this service? Enter 'y' to confirm.");
                        if( Console.ReadLine() == "y")
                            SelfInstaller.InstallMe(service_assembly.Location, args);
                        else
                            Console.WriteLine("Skip installation and exit");
                        return;
                    }
                    Console.WriteLine(Environment.NewLine + Environment.NewLine + "Service is already installed");
                    return;
                }
                // First parameter is always i (install) or u (uninstall) flags.
                switch(args[0].ToLower())
                {
                    default:
                        break;
                    case "-i" :
                    case "/i" :
                        SelfInstaller.InstallMe(service_assembly.Location, args);
                        return;
                    case "-u" :
                    case "/u" :
                        SelfInstaller.UninstallMe(service_assembly.Location);
                        return;
                }

                // Show usage
                Console.WriteLine(Environment.NewLine + Environment.NewLine + "Usage: MyService.exe [/i | /u]" + Environment.NewLine + Environment.NewLine + "Where:");
                Console.WriteLine("       /i - install service;");
                Console.WriteLine("       /u - uninstall service.");
            }
            // Started by SCM
            else
            {
                System.ServiceProcess.ServiceBase[] ServicesToRun;
                // More than one user Service may run within the same process. To add
                // another service to this process, change the following line to
                // create a second service object. For example,
                ServicesToRun = new System.ServiceProcess.ServiceBase[] { service };
                System.ServiceProcess.ServiceBase.Run(ServicesToRun);
            }
        }
    }
}
